<?php
// تعریف مسیر فایل config.php
$configFilePath = dirname(__DIR__) . '/config.php';

// اگر درخواست از نوع POST و شامل "action" باشد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');

    if ($_POST['action'] === 'add_domain' && isset($_POST['domain'])) {
        $userDomain = trim($_POST['domain']);
        
        // اعتبار سنجی ساده لینک
        if (filter_var($userDomain, FILTER_VALIDATE_URL)) {
            // اضافه کردن /chatino-files به انتهای دامنه
            $formattedDomain = rtrim($userDomain, '/') . '/chatino-files';

            // خواندن محتویات فایل config.php
            $configContent = file_get_contents($configFilePath);

            // پیدا کردن تعریف SB_CROSS_DOMAIN_URL
            if (preg_match("/define\('SB_CROSS_DOMAIN_URL',\s*(.*?)\);/", $configContent, $matches)) {
                $currentDefine = $matches[0];
                $currentUrlValue = $matches[1]; // این میتونه یک رشته یا آرایه ای از رشته ها باشه

                $newUrlValue = '';

                // اگر در حال حاضر یک آرایه باشد
                if (strpos($currentUrlValue, '[') === 0) {
                    // حذف براکت ها و تقسیم به رشته ها
                    $urls = explode('", "', trim($currentUrlValue, '[]"'));
                    
                    // اضافه کردن دامنه جدید اگر وجود ندارد
                    if (!in_array($formattedDomain, $urls)) {
                        $urls[] = $formattedDomain;
                    }
                    $newUrlValue = '["' . implode('", "', $urls) . '"]';
                } else {
                    // اگر یک رشته تکی باشد
                    $currentSingleUrl = trim($currentUrlValue, "'\"");
                    if ($currentSingleUrl === 'YOUR-URL' || empty($currentSingleUrl)) { // اگر مقدار پیش فرض یا خالی بود
                        $newUrlValue = "'" . $formattedDomain . "'";
                    } elseif ($currentSingleUrl === $formattedDomain) { // اگر همین دامنه از قبل اضافه شده بود
                        $newUrlValue = "'" . $formattedDomain . "'";
                    } else { // اگر یک دامنه دیگر بود، آن را به آرایه تبدیل کن
                        $newUrlValue = '["' . $currentSingleUrl . '", "' . $formattedDomain . '"]';
                    }
                }
                
                $newDefine = "define('SB_CROSS_DOMAIN_URL', " . $newUrlValue . ");";
                $updatedConfigContent = str_replace($currentDefine, $newDefine, $configContent);

            } else {
                // اگر SB_CROSS_DOMAIN_URL وجود نداشت، آن را در انتهای فایل اضافه کن
                $newDefine = "\ndefine('SB_CROSS_DOMAIN_URL', '" . $formattedDomain . "');\n";
                $updatedConfigContent = rtrim($configContent, '?>') . $newDefine . '?>';
            }

            // نوشتن محتویات جدید در فایل config.php
            if (file_put_contents($configFilePath, $updatedConfigContent) !== false) {
                echo json_encode(['success' => true, 'message' => 'دامنه با موفقیت اضافه شد.', 'domain' => $formattedDomain]);
            } else {
                echo json_encode(['success' => false, 'message' => 'خطا در نوشتن فایل config.php.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'لطفاً یک لینک معتبر وارد کنید.']);
        }
    }
    exit();
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>افزودن دامنه کراس‌دامنه</title>
    <style>
        @font-face {
            font-family: 'IRANSansXVF';
            src: url('IRANSansXVF.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'IRANSansXVF', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            background-color: #f0f2f5;
            direction: rtl; /* برای پشتیبانی از زبان فارسی */
        }

        .container {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 100%;
            max-width: 500px;
            box-sizing: border-box;
        }

        h2 {
            color: #333;
            margin-bottom: 25px;
        }

        .form-section {
            margin-bottom: 20px;
        }

        input[type="text"] {
            width: calc(100% - 20px);
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box;
            font-family: 'IRANSansXVF', sans-serif;
            font-size: 1rem;
        }

        button {
            background-color: #007bff;
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1rem;
            font-family: 'IRANSansXVF', sans-serif;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #0056b3;
        }

        .message {
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            font-weight: bold;
        }

        .message.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .download-section {
            display: none; /* در ابتدا مخفی */
            margin-top: 20px;
            text-align: center;
        }

        .download-section p {
            font-size: 1.1rem;
            line-height: 1.6;
            color: #555;
        }

        .download-button {
            background-color: #28a745;
        }

        .download-button:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>افزودن دامنه</h2>
        
        <div class="form-section" id="formSection">
            <input type="text" id="domainInput" placeholder="مثال: https://example.com" required>
            <button id="addDomainButton">افزودن دامنه</button>
            <div id="message" class="message"></div>
        </div>

        <div class="download-section" id="downloadSection">
            <p>فایل زیر را دانلود کرده و در شاخه اصلی دامنه وارد شده (<span id="displayDomain"></span>) آپلود کنید.</p>
            <button class="download-button" onclick="window.location.href = './chatino-files.zip';">دانلود فایل</button>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const domainInput = document.getElementById('domainInput');
            const addDomainButton = document.getElementById('addDomainButton');
            const messageDiv = document.getElementById('message');
            const formSection = document.getElementById('formSection');
            const downloadSection = document.getElementById('downloadSection');
            const displayDomain = document.getElementById('displayDomain');

            addDomainButton.addEventListener('click', function() {
                const domain = domainInput.value;
                if (!domain) {
                    showMessage('لطفاً یک دامنه وارد کنید.', 'error');
                    return;
                }

                // ارسال درخواست AJAX
                fetch('index.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `action=add_domain&domain=${encodeURIComponent(domain)}`
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        showMessage(data.message, 'success');
                        displayDomain.textContent = domain; // نمایش دامنه اصلی وارد شده توسط کاربر
                        formSection.style.display = 'none'; // مخفی کردن فرم
                        downloadSection.style.display = 'block'; // نمایش بخش دانلود
                    } else {
                        showMessage(data.message, 'error');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showMessage('خطا در ارتباط با سرور.', 'error');
                });
            });

            function showMessage(msg, type) {
                messageDiv.textContent = msg;
                messageDiv.className = `message ${type}`; // تغییر کلاس برای استایل دهی
                messageDiv.style.display = 'block'; // مطمئن شویم که پیام نمایش داده می شود
            }
        });
    </script>
</body>
</html>