<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تولید کد چتینو</title>
    <style>
        @font-face {
            font-family: 'IRANSansX';
            src: url('./fonts/IRANSansXVF.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'IRANSansX', sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: #F5F7FA;
            color: #333;
            direction: rtl; /* برای راست به چپ کردن کل صفحه */
            text-align: right;
        }
        button {
    font-family: 'IRANSansX' !important;
}

        .container {
            background-color: #fff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            width: 90%;
            max-width: 500px;
            box-sizing: border-box;
            text-align: center;
        }

        h1 {
            color: #4CAF50;
            margin-bottom: 25px;
            font-size: 24px;
        }

        .info-box {
            background-color: #e8f5e9; /* Light green */
            color: #2e7d32; /* Darker green */
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 15px;
            text-align: right;
        }

        label {
            display: block;
            margin-bottom: 10px;
            font-size: 16px;
            font-weight: bold;
            text-align: right; /* برای راست به چپ کردن متن لیبل */
        }

        input[type="text"] {
            width: calc(100% - 20px);
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 15px;
            box-sizing: border-box;
            text-align: left; /* برای اینکه متن وارد شده در فیلد از چپ به راست نمایش داده شود */
            direction: ltr; /* برای ورودی فیلد */
        }

        button {
            background-color: #4CAF50;
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #45a049;
        }

        .loading-animation {
            display: none;
            margin: 20px auto;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #4CAF50;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        #result-box {
            display: none;
            margin-top: 25px;
            text-align: left; /* برای نمایش کد از چپ به راست */
        }

        #generated-code {
            background-color: #f8f8f8;
            border: 1px solid #eee;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', Courier, monospace;
            font-size: 14px;
            white-space: pre-wrap; /* برای حفظ فرمت کد */
            word-break: break-all; /* برای جلوگیری از سرریز شدن متن */
            direction: ltr; /* برای نمایش کد از چپ به راست */
        }

        #copy-button {
            margin-top: 15px;
            background-color: #007bff;
        }

        #copy-button:hover {
            background-color: #0056b3;
        }

        /* Responsive adjustments */
        @media (max-width: 600px) {
            .container {
                padding: 20px;
                width: 95%;
            }

            input[type="text"], button {
                font-size: 14px;
                padding: 10px;
            }

            h1 {
                font-size: 20px;
            }
            .info-box {
                font-size: 14px;
                padding: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>تولید کد اسکریپت چتینو</h1>

        <div id="input-section">
            <div class="info-box">
                لطفا لینک محل نصب اسکریپت چتینو را در فیلد زیر وارد کنید
            </div>
            <label for="domain-input">لینک اسکریپت چتینو</label>
            <input type="text" id="domain-input" placeholder="دامنه خود را با https:// وارد کنید" value="https://">
            <button id="generate-button">تولید کد</button>
        </div>

        <div id="loading-message" class="loading-animation"></div>
        <p id="status-message" style="display: none; color: #555; margin-top: 15px;">در حال تولید کد...</p>

        <div id="result-box">
            <label for="generated-code">کد تولید شده:</label>
            <textarea id="generated-code" rows="6" readonly></textarea>
            <button id="copy-button">کپی کردن کد</button>
        </div>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#generate-button').on('click', function() {
                var domain = $('#domain-input').val().trim();

                if (domain === '' || domain === 'https://' || !domain.startsWith('https://')) {
                    alert('لطفاً دامنه خود را به صورت کامل و با "https://" وارد کنید.');
                    return;
                }

                // نمایش پیام در حال تولید کد و انیمیشن لودینگ
                $('#input-section').hide(); // مخفی کردن بخش ورودی (شامل فیلد و دکمه و باکس اطلاعات)
                $('#status-message').text('در حال تولید کد...').show();
                $('#loading-message').show();
                $('#result-box').hide();

                // شبیه‌سازی تأخیر برای تولید کد (در واقعیت ممکن است پردازش سمت سرور باشد)
                setTimeout(function() {
                    var scriptCode = '<script src="' + domain + '/js/min/jquery.min.js"></' + 'script>\n';
                    scriptCode += '<script id="sbinit" src="' + domain + '/js/main.js?lang=fa"></' + 'script>';

                    $('#generated-code').val(scriptCode);

                    // مخفی کردن پیام لودینگ و نمایش نتیجه
                    $('#status-message').hide();
                    $('#loading-message').hide();
                    $('#result-box').show();

                }, 1500); // 1.5 ثانیه تأخیر
            });

            $('#copy-button').on('click', function() {
                var copyText = $('#generated-code');
                copyText.select();
                document.execCommand('copy');
                alert('کد با موفقیت کپی شد!');
            });
        });
    </script>
</body>
</html>